<?php
$require_admin = true; // Ensure only admins can access this
require_once 'auth_check.php';
require_once 'db_connect.php';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    $action = $_POST['action'];

    // Common fields for add/edit
    $mall_id = isset($_POST['mall_id']) ? intval($_POST['mall_id']) : null;
    $level = isset($_POST['level']) ? trim($_POST['level']) : null;
    $unit_id_display = isset($_POST['unit_id_display']) ? trim($_POST['unit_id_display']) : null;
    $status = isset($_POST['status']) ? trim($_POST['status']) : 'Available';
    $area = isset($_POST['area']) ? trim($_POST['area']) : null;
    $water_point = isset($_POST['water_point']) ? trim($_POST['water_point']) : null;
    $ac_power = isset($_POST['ac_power']) ? trim($_POST['ac_power']) : null;
    $fcu_units = isset($_POST['fcu_units']) ? trim($_POST['fcu_units']) : null;
    $elec_isolator = isset($_POST['elec_isolator']) ? trim($_POST['elec_isolator']) : null;
    $elec_phase = isset($_POST['elec_phase']) ? trim($_POST['elec_phase']) : null;
    $emergency_light = isset($_POST['emergency_light']) ? trim($_POST['emergency_light']) : null;
    $exit_signage = isset($_POST['exit_signage']) ? trim($_POST['exit_signage']) : null;
    $pa_speaker = isset($_POST['pa_speaker']) ? trim($_POST['pa_speaker']) : null;
    $fibre_port = isset($_POST['fibre_port']) ? trim($_POST['fibre_port']) : null;
    $data_port = isset($_POST['data_port']) ? trim($_POST['data_port']) : null;
    $water_pipe_dia = isset($_POST['water_pipe_dia']) ? trim($_POST['water_pipe_dia']) : null;
    $floor_trap = isset($_POST['floor_trap']) ? trim($_POST['floor_trap']) : null;
    $gas_pipe = isset($_POST['gas_pipe']) ? trim($_POST['gas_pipe']) : null;
    $kitchen_ea = isset($_POST['kitchen_ea']) ? trim($_POST['kitchen_ea']) : null;
    $kitchen_fa = isset($_POST['kitchen_fa']) ? trim($_POST['kitchen_fa']) : null;
    $sprinkler = isset($_POST['sprinkler']) ? trim($_POST['sprinkler']) : null;
    $other_notes = isset($_POST['other_notes']) ? trim($_POST['other_notes']) : null;
    $detail_plan_image_path = isset($_POST['detail_plan_image_path']) ? trim($_POST['detail_plan_image_path']) : null;
    $floor_plan_image_path = isset($_POST['floor_plan_image_path']) ? trim($_POST['floor_plan_image_path']) : null;


    if ($action == 'add_unit' || $action == 'edit_unit') {
        // Validation (basic example)
        if (empty($mall_id) || empty($level) || empty($unit_id_display)) {
            $_SESSION['admin_message'] = "Mall, Level, and Unit ID are required.";
            $_SESSION['admin_error'] = true;
            header("Location: ../admin.php");
            exit;
        }

        // Prepare SQL statement
        if ($action == 'add_unit') {
            $sql = "INSERT INTO units (mall_id, level, unit_id_display, status, area, water_point, ac_power, fcu_units, elec_isolator, elec_phase, emergency_light, exit_signage, pa_speaker, fibre_port, data_port, water_pipe_dia, floor_trap, gas_pipe, kitchen_ea, kitchen_fa, sprinkler, other_notes, detail_plan_image_path, floor_plan_image_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        } else { // edit_unit
            $unit_db_id = isset($_POST['unit_db_id']) ? intval($_POST['unit_db_id']) : 0;
            if ($unit_db_id <= 0) {
                $_SESSION['admin_message'] = "Invalid Unit Database ID for editing.";
                $_SESSION['admin_error'] = true;
                header("Location: ../admin.php");
                exit;
            }
            $sql = "UPDATE units SET mall_id=?, level=?, unit_id_display=?, status=?, area=?, water_point=?, ac_power=?, fcu_units=?, elec_isolator=?, elec_phase=?, emergency_light=?, exit_signage=?, pa_speaker=?, fibre_port=?, data_port=?, water_pipe_dia=?, floor_trap=?, gas_pipe=?, kitchen_ea=?, kitchen_fa=?, sprinkler=?, other_notes=?, detail_plan_image_path=?, floor_plan_image_path=? WHERE id=?";
        }

        if ($stmt = $conn->prepare($sql)) {
            if ($action == 'add_unit') {
                $stmt->bind_param("isssssssssssssssssssssss",
                    $mall_id, $level, $unit_id_display, $status, $area, $water_point, $ac_power, $fcu_units, $elec_isolator, $elec_phase, $emergency_light, $exit_signage, $pa_speaker, $fibre_port, $data_port, $water_pipe_dia, $floor_trap, $gas_pipe, $kitchen_ea, $kitchen_fa, $sprinkler, $other_notes, $detail_plan_image_path, $floor_plan_image_path);
            } else { // edit_unit
                $stmt->bind_param("isssssssssssssssssssssssi",
                    $mall_id, $level, $unit_id_display, $status, $area, $water_point, $ac_power, $fcu_units, $elec_isolator, $elec_phase, $emergency_light, $exit_signage, $pa_speaker, $fibre_port, $data_port, $water_pipe_dia, $floor_trap, $gas_pipe, $kitchen_ea, $kitchen_fa, $sprinkler, $other_notes, $detail_plan_image_path, $floor_plan_image_path, $unit_db_id);
            }

            if ($stmt->execute()) {
                $_SESSION['admin_message'] = ($action == 'add_unit') ? "Unit added successfully." : "Unit updated successfully.";
            } else {
                $_SESSION['admin_message'] = "Error: " . $stmt->error;
                $_SESSION['admin_error'] = true;
            }
            $stmt->close();
        } else {
            $_SESSION['admin_message'] = "Error preparing statement: " . $conn->error;
            $_SESSION['admin_error'] = true;
        }

    } elseif ($action == 'delete_unit') {
        $unit_db_id = isset($_POST['unit_db_id']) ? intval($_POST['unit_db_id']) : 0;
        if ($unit_db_id <= 0) {
            $_SESSION['admin_message'] = "Invalid Unit ID for deletion.";
            $_SESSION['admin_error'] = true;
        } else {
            $sql = "DELETE FROM units WHERE id = ?";
            if ($stmt = $conn->prepare($sql)) {
                $stmt->bind_param("i", $unit_db_id);
                if ($stmt->execute()) {
                    $_SESSION['admin_message'] = "Unit deleted successfully.";
                } else {
                    $_SESSION['admin_message'] = "Error deleting unit: " . $stmt->error;
                    $_SESSION['admin_error'] = true;
                }
                $stmt->close();
            } else {
                $_SESSION['admin_message'] = "Error preparing delete statement: " . $conn->error;
                $_SESSION['admin_error'] = true;
            }
        }
    } else {
        $_SESSION['admin_message'] = "Invalid action specified.";
        $_SESSION['admin_error'] = true;
    }

    $conn->close();
    header("Location: ../admin.php"); // Redirect back to admin page
    exit;

} else {
    // If not a POST request or no action, redirect or show error
    $_SESSION['admin_message'] = "Invalid request.";
    $_SESSION['admin_error'] = true;
    header("Location: ../admin.php");
    exit;
}
?>