<?php
// This file can be included at the top of pages that require authentication.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// If the user is not logged in, redirect to login page
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

// If the page requires admin access, check if the user is an admin
// You can define a variable like $require_admin = true; on specific admin pages before including this.
if (isset($require_admin) && $require_admin === true) {
    if (!isset($_SESSION["is_admin"]) || $_SESSION["is_admin"] !== true) {
        // Not an admin, redirect to a non-admin page or show an error
        // For simplicity, redirecting to index.php or mall_selection.php might be suitable.
        // Or, you could display an "access denied" message.
        $_SESSION['error_message'] = "Access denied. Admin privileges required.";
        header("location: ../index.php"); // Or mall_selection.php
        exit;
    }
}
?>