<?php
require_once 'php/auth_check.php'; // Ensure user is logged in
require_once 'php/db_connect.php';

// Fetch malls from the database
$malls = [];
// For the sales kit, we assume files are PDFs. You can change '.pdf' to another extension if needed.
$sales_kit_folder = 'sales_kits/'; // The folder where sales kits are stored.

$sql = "SELECT id, name, slug FROM malls ORDER BY name ASC";
if ($result = $conn->query($sql)) {
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $malls[] = $row;
        }
    }
    $result->free();
} else {
    // Handle error, e.g., log it or display a generic message
    $error_message = "Error fetching mall data: " . $conn->error;
}
$conn->close();

$pageTitle = "Download Sales Kit";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?> - Mall Leasing</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Using the same CSS from mall_selection.php for consistency */
        :root {
            --primary-color: #007bff;
            --primary-hover-color: #0056b3;
            --danger-color: #dc3545; /* Red for unavailable files */
            --danger-hover-color: #c82333; /* Darker red */
            --background-color: #f8f9fa;
            --card-background: #ffffff;
            --text-color: #343a40;
            --heading-color: #212529;
            --border-color: #e9ecef;
            --shadow-color: rgba(0, 0, 0, 0.08);
            --link-color: #007bff;
            --link-hover-color: #0056b3;
        }
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: var(--background-color);
            color: var(--text-color);
        }
        .container {
            background: var(--card-background);
            padding: 3rem 2.5rem;
            border-radius: 12px;
            box-shadow: 0 10px 30px var(--shadow-color);
            text-align: center;
            width: 90%;
            max-width: 550px;
            border: 1px solid var(--border-color);
        }
        h1 {
            margin-bottom: 2rem;
            color: var(--heading-color);
            font-weight: 700;
            font-size: 2.2em;
        }
        .download-button {
            display: block;
            width: calc(100% - 20px);
            padding: 1.2rem 1.5rem;
            margin: 1rem auto;
            background-color: var(--primary-color);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-size: 1.15em;
            font-weight: 600;
            transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.3s ease;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            border: none;
            cursor: pointer;
            text-align: center;
        }
        .download-button:hover {
            background-color: var(--primary-hover-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        }
        .download-button i {
            margin-right: 10px;
        }

        /* ▼▼▼ NEW STYLE FOR UNAVAILABLE BUTTONS ▼▼▼ */
        .download-button.unavailable {
            background-color: var(--danger-color);
            cursor: not-allowed;
            box-shadow: none;
        }
        .download-button.unavailable:hover {
            background-color: var(--danger-hover-color);
            transform: none; /* No lift effect */
            box-shadow: none;
        }

        .footer-links {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 1.5rem;
            margin-top: 2.5rem;
        }
        .footer-links a {
            color: var(--link-color);
            text-decoration: none;
            font-weight: 500;
            font-size: 1em;
            transition: color 0.3s ease;
        }
        .footer-links a:hover {
            color: var(--link-hover-color);
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><?php echo htmlspecialchars($pageTitle); ?></h1>

        <?php if (isset($error_message)): ?>
            <p style="color: red;"><?php echo htmlspecialchars($error_message); ?></p>
        <?php endif; ?>

        <?php if (!empty($malls)): ?>
            <?php foreach ($malls as $mall): ?>
                <?php
                    // ▼▼▼ UPDATED LOGIC TO CHECK IF FILE EXISTS ▼▼▼
                    $file_path = $sales_kit_folder . htmlspecialchars($mall['slug']) . '.pdf';
                    $is_available = file_exists($file_path);

                    // Set button properties based on file availability
                    $button_class = 'download-button' . ($is_available ? '' : ' unavailable');
                    $button_href = $is_available ? $file_path : 'javascript:void(0);';
                    $download_attr = $is_available ? 'download' : '';
                    $icon_class = $is_available ? 'fas fa-file-download' : 'fas fa-times-circle';
                    $button_text = htmlspecialchars($mall['name']);
                ?>
                <a href="<?php echo $button_href; ?>" class="<?php echo $button_class; ?>" <?php echo $download_attr; ?>>
                    <i class="<?php echo $icon_class; ?>"></i>
                    <?php echo $button_text; ?>
                </a>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No properties available to download sales kits for.</p>
        <?php endif; ?>

        <div class="footer-links">
             <a href="mall_selection.php">Back to Property Selection</a>
             <a href="php/logout.php">Logout</a>
        </div>
    </div>
</body>
</html>